/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.util;

import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger log = LoggerFactory.getLogger(FileUtils.class);
    public static final String BACKUP_FILE_EXTENSION = ".old";

    private FileUtils() {
    }

    public static void stringToFile(String str, File file) throws IOException {
        try (BufferedWriter writer = Files.newWriter(file, StandardCharsets.UTF_8);){
            writer.write(str);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String fileAsString(File file) throws IOException {
        try (BufferedReader reader = null;){
            reader = Files.newReader(file, StandardCharsets.UTF_8);
            StringBuilder data = new StringBuilder(1000);
            char[] buf = new char[16384];
            int numRead = 0;
            while ((numRead = reader.read(buf)) != -1) {
                data.append(buf, 0, numRead);
            }
            String string = data.toString();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File src, File dest) throws IOException {
        try (FileInputStream in = new FileInputStream(src);
             FileOutputStream out = new FileOutputStream(dest);){
            int len;
            byte[] buf = new byte[16384];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
        }
    }

    public static File createTempDirectory() {
        File temp = null;
        try {
            temp = File.createTempFile("temp", Long.toString(System.nanoTime()));
        }
        catch (IOException e) {
            log.error("Could create temp file.");
        }
        if (temp != null && !temp.delete()) {
            log.error("Could not delete temp file " + temp.getAbsolutePath());
            temp = null;
        }
        if (temp != null && !temp.mkdir()) {
            log.error("Could not create temp dir " + temp.getAbsolutePath());
            temp = null;
        }
        return temp;
    }

    public static boolean deleteDirectory(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    FileUtils.deleteDirectory(files[i]);
                    continue;
                }
                if (files[i].delete()) continue;
                log.warn("Cannot delete file {}", (Object)files[i]);
            }
        }
        return path.delete();
    }

    public static void collect(@Nonnull File fromDir, @Nonnull List<File> to, @Nonnull FileFilter filter, boolean recursive, boolean includeDirectories) {
        File[] files;
        if (!fromDir.isDirectory()) {
            throw new IllegalStateException(fromDir + " is not a directory.");
        }
        for (File f : files = fromDir.listFiles()) {
            if (f.isDirectory()) {
                if (includeDirectories && filter.accept(f)) {
                    to.add(f);
                }
                if (!recursive) continue;
                FileUtils.recursivelyCollect(f, to, filter);
                continue;
            }
            if (!filter.accept(f)) continue;
            to.add(f);
        }
    }

    public static void collect(@Nonnull File fromDir, @Nonnull List<File> to, @Nonnull FileFilter filter, boolean recursive) {
        FileUtils.collect(fromDir, to, filter, recursive, false);
    }

    public static void recursivelyCollect(@Nonnull File fromDir, @Nonnull List<File> to, @Nonnull FileFilter filter) {
        FileUtils.collect(fromDir, to, filter, true, false);
    }

    public static void ensureDirectory(@Nonnull File dir) throws IOException {
        if (!dir.exists()) {
            log.info("Directory {} does not exist. Creating it now.", (Object)dir);
            if (!dir.mkdirs()) {
                throw new IOException(String.format("Could not create directory %s.", dir));
            }
        }
        if (!dir.isDirectory()) {
            throw new IOException(String.format("A file (non-directory) %s already exists, cannot create such directory.", dir));
        }
    }

    public static void ensureDirectory(@Nonnull Path dir) throws IOException {
        FileUtils.ensureDirectory(dir.toFile());
    }

    public static void ensureDirectoryForFile(File file) throws IOException {
        FileUtils.ensureDirectory(file.getParentFile());
    }

    public static void createBackupFile(File file) throws IOException {
        if (file.exists()) {
            File backupFile = new File(file.getPath() + BACKUP_FILE_EXTENSION);
            Files.copy(file, backupFile);
            backupFile.setLastModified(file.lastModified());
        }
    }

    public static void restoreBackupFile(File file) {
        File backupFile = new File(file.getPath() + BACKUP_FILE_EXTENSION);
        if (!backupFile.exists()) {
            return;
        }
        boolean deleted = true;
        if (file.exists()) {
            deleted = file.delete();
        }
        if (deleted && backupFile.renameTo(file)) {
            log.warn("Unable to restore backup file: " + backupFile.getPath());
        }
    }

    public static void deleteBackupFile(File file) {
        File backupFile = new File(file.getPath() + BACKUP_FILE_EXTENSION);
        if (backupFile.exists() && !backupFile.delete()) {
            log.warn("Unable to delete backup file: " + backupFile.getPath());
        }
    }
}

